# Fachklasse
class Turnier:
    def __init__(self):
        self.bezeichnung = ""
        self.anz_teilnehmer = 0
        self.startgeld = 0.0
        self.preis_1 = 0
        self.preis_2 = 0
        self.preis_3 = 0
        
    def berechne_gewinn(self):
        """ Berechne den erzielten Gewinn"""
        umsatz = self.startgeld * self.anz_teilnehmer
        kosten = self.preis_1 + self.preis_2 + self.preis_3
        gewinn = umsatz - kosten
        return gewinn
    
    def berechne_startgeld(self,p_gewinn):
        """ Berechne das notwendige Startgeld, um einen Gewinn
            von p_gewinn zu erzielen """
        kosten = self.preis_1 + self.preis_2 + self.preis_3
        umsatz = kosten + p_gewinn
        startgeld = round(umsatz / self.anz_teilnehmer,2)
        return startgeld
    
    def anzeigen(self):
        print(self.bezeichnung)
        print("Anzahl Teilnehmer:",self.anz_teilnehmer)
        print("Startgeld:",self.startgeld,"Euro")
        print("Preis für den 1. Platz:",self.preis_1,"Euro")
        print("Preis für den 2. Platz:",self.preis_2,"Euro")
        print("Preis für den 3. Platz:",self.preis_3,"Euro")
        print("Gewinn:",self.berechne_gewinn(),"Euro")

# Hauptprogramm
t = Turnier()
t.bezeichnung = "1. Stuttgarter Pokermeisterschaft"
t.anz_teilnehmer = 80
t.startgeld = 4.80
t.preis_1 = 120
t.preis_2 = 80
t.preis_3 = 40

t.anzeigen()
gewinn_soll = float(input("Gewünschter Gewinn:"))
startgeld_soll = t.berechne_startgeld(gewinn_soll)
print("Hierfür ist ein Startgeld von", startgeld_soll,"Euro notwendig.")