import sys
from Konto import *
from PyQt5 import QtWidgets, uic

class MeinDialog(QtWidgets.QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.ui = uic.loadUi("MeinDialog3.ui", self)
        # Objekt anlegen
        global k
        k = Konto(66124457, 450.00, "Peter Schmidt")
        self.ui.ta_ausgabe.setPlainText("Hallo " + k.inhaber + "!")
        self.ui.ta_ausgabe.appendPlainText("Ihre Kontonummer: " + str(k.kontonummer))
        self.ui.ta_ausgabe.appendPlainText("Aktueller Kontostand: " + str(k.kontostand) + " Euro")
        # Slot einrichten
        self.ui.bt_starten.clicked.connect(self.on_starten)
        
    def on_starten(self):
        # Daten einlesen
        betrag = float(self.ui.tf_betrag.text())
        # Methode aufrufen
        if self.ui.rb_einzahlen.isChecked():
            k.einzahlen(betrag)
            self.ui.ta_ausgabe.appendPlainText("Es wurden " + str(betrag) + " Euro eingezahlt.")
        if self.ui.rb_auszahlen.isChecked():
            k.auszahlen(betrag)
            self.ui.ta_ausgabe.appendPlainText("Es wurden " + str(betrag) + " Euro ausgezahlt.")
        # Daten ausgeben
        self.ui.ta_ausgabe.appendPlainText("Neuer Kontostand: "+ str(k.kontostand) + " Euro")
        
app = QtWidgets.QApplication(sys.argv)
dialog = MeinDialog()
dialog.show()
sys.exit(app.exec_())