import sys
from Ort import *
from PyQt5 import QtWidgets, uic

class MeinDialog(QtWidgets.QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.ui = uic.loadUi("MeinDialog.ui", self)

        # Slot einrichten
        self.ui.bt_berechnen.clicked.connect(self.on_berechnen)
        
    def on_berechnen(self):
            
        # Daten einlesen
        ort1 = Ort()
        ort2 = Ort()
        
        ort1.name = self.ui.tf_ort1.text()
        ort1.breite = float(self.ui.tf_breite1.text())
        ort1.laenge = float(self.ui.tf_laenge1.text())
        ort2.name = self.ui.tf_ort2.text()
        ort2.breite = float(self.ui.tf_breite2.text())
        ort2.laenge = float(self.ui.tf_laenge2.text())
        
        # Methode aufrufen
        dist = ort1.berechne_distanz(ort2)
        dist = round(dist, 0)
        
        # Daten ausgeben
        self.ui.ta_ausgabe.setPlainText("Die Entfernung zwischen " + ort1.name + " und " + ort2.name + " beträgt " + str(dist) + " km.")

app = QtWidgets.QApplication(sys.argv)
dialog = MeinDialog()
dialog.show()
sys.exit(app.exec_())

        