import sys
from Artikel import *
from PyQt5 import QtWidgets, uic

class MeinDialog(QtWidgets.QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.ui = uic.loadUi("MeinDialog.ui", self)
        
        # Objekt anlegen
        global artikel
        global artikelliste
        artikelliste = []
        
        # Slot einrichten
        self.ui.bt_anlegen.clicked.connect(self.on_anlegen)
        self.ui.bt_ausgeben.clicked.connect(self.on_ausgeben)
    
    def on_anlegen(self):
        
        # Daten einlesen
        artikel = Artikel()
        
        artikel.artikelnr = int(self.ui.tf_artikelnr.text())
        artikel.bezeichnung = self.ui.tf_bezeichnung.text()
        artikel.nettopreis = float(self.ui.tf_nettopreis.text())
        if self.ui.rb_ermaessigt.isChecked():
            artikel.reduzierte_steuer = True
        if self.ui.rb_standard.isChecked():
            artikel.reduzierte_steuer = False
        artikelliste.append(artikel)
        self.ui.ta_ausgabe.setPlainText("Artikel erfolgreich angelegt")
        
    def on_ausgeben(self):
        self.ui.ta_ausgabe.setPlainText("")
        for artikel in artikelliste:
            self.ui.ta_ausgabe.appendPlainText(artikel.ausgeben())
        
app = QtWidgets.QApplication(sys.argv)
dialog = MeinDialog()
dialog.show()
sys.exit(app.exec_())

        